 ; Ŀ
 ;   Atcase - change the prompt string in an attdef to mostly lower case.  
 ;   Copyright 1996, 2001 by Rocket Software Ltd.                          
 ;   You catch more flies with honey than dynamite.                        
 ; 

 ; Ŀ
 ;   Subroutine Splat - divide a text string into a list of substrings.    
 ;   Arguments: Sepchr, the field separator character.                     
 ;              Linn, the text string.                                     
 ;   Returns a list of field values, removes leading and trailing spaces.  
 ; 
 (DEFUN SPLAT (sepchr linn / len pos name1 strlst)
  (while (/= (strlen linn) 0)
         (while (and (= (substr linn 1 1) " ")
                     (/= (strlen linn) 0))
                (setq linn (substr linn 2)))
         (while (= (substr linn (setq len (strlen linn))) " ")
                (setq linn (substr linn 1 (1- len))))
         (setq pos 1)
         (setq len (strlen linn))
         (while (and (/= (substr linn pos 1) sepchr)
                     (>= len pos))
                (setq pos (1+ pos)))
         (setq name1 (substr linn 1 (1- pos)))
         (while (= (substr name1 (setq len (strlen linn))) " ")
                (setq name1 (substr name1 1 (1- len))))
         (setq linn (substr linn (1+ pos)))
         (setq strlst (append strlst (list name1))))
  (if (null strlst) (setq strlst (list "")))
  strlst)
 ; Ŀ
 ;   Splat end.                                                            
 ; 

 ; Ŀ
 ;   Hug - string capitaliser.  Takes one argument, a string, and returns  
 ;   a list: the string with the first letter changed to upper case and    
 ;   T if this changed the string, () if not.                              
 ; 
 (DEFUN HUG (exstr / nustr)
  (setq nustr (strcat (strcase (substr exstr 1 1))
                      (strcase (substr exstr 2) t)))
 (list nustr (if (= exstr nustr) () t)))
 ; Ŀ
 ;   Hug - end.                                                            
 ; 

 ; Ŀ
 ;   Atcase.                                                               
 ; 
 (DEFUN C:ATCASE (/ ss num enam entt sub prlist nustra)
  (prompt "Select attdefs: ")
  (setq ss (ssget (list (cons 0 "attdef"))))
  (setq num 0)
  (while (and ss (setq enam (ssname ss num)))
         (setq num (1+ num))
         (setq prom (cdr (setq asoc3 (assoc 3 (setq entt (entget enam))))))
         (setq prlist (splat " " prom))
         (setq nustra "")
         (while (setq sub (car prlist))
                (setq prlist (cdr prlist))
                (setq nustra (strcat nustra " " (car (hug sub)))))
         (if (= (substr nustra 1 1) " ") (setq nustra (substr nustra 2)))
         (entmod (subst (cons 3 nustra) asoc3 entt)))
 (princ))